% GETFILTERDEFS Estimate a position for each query element using weighted
% centroid.
%
%	[DEFS] = GETFILTERDEFS() returns constants useful for filtering for
%	specific data or parameter options for some functions .
%
%   Copyright  2018 Universitat Jaume I (UJI)

% Permission is hereby granted, free of charge, to any person obtaining a copy of
% this software and associated documentation files (the "Software"), to deal in
% the Software without restriction, including without limitation the rights to
% use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
% of the Software, and to permit persons to whom the Software is furnished to do
% so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all
% copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

function [defs] = getDeploymentDefs()
    defs = struct;

    % Amount of databases
    defs.setsAmount = 3;
    
    % Phones used
    defs.phones(1).name = 'Bq Aquaris';
    defs.phones(2).name = 'Sansung';
    defs.phones(3).name = 'Xiaomi Mi 8';
    
    % Set names
    defs.set(1).name = 'Physics_1';
    defs.set(2).name = 'Physics_2';
    defs.set(3).name = 'Physics_and_Mathematics';
    % -----------------------------------
    
    defs.set(1).phones = [1 2 3];
    defs.set(1).id = 1;
    defs.set(1).nBeacons = 180;
    defs.set(1).nRP = 173;
    
    defs.set(2).phones = [1 2 3];
    defs.set(2).id = 2;
    defs.set(2).nBeacons = 180;
    defs.set(2).nRP = 230;
    
    defs.set(3).phones = [1 2];
    defs.set(3).id = 3;
    defs.set(3).nBeacons = 180;
    defs.set(3).nRP = 150;
    
    % -----------------------------------

    defs.buffering.window.s2 = 2;
    defs.buffering.window.s3 = 3;
    defs.buffering.window.s4 = 4;
    defs.buffering.window.s5 = 5;
    defs.buffering.window.allSizes = (2:5);
    
    defs.buffering.summary.last = 1;
    defs.buffering.summary.mean = 2;
end

